@extends('installer.layout')

@section('title', 'Database')
@section('subtitle', 'Configure your database connection')

@section('content')
    <h2 style="margin-bottom: var(--spacing-lg); color: var(--white);">Database Configuration</h2>
    
    <p style="margin-bottom: var(--spacing-lg);">
        Enter your database connection details below. The installer will verify the connection before proceeding.
    </p>
    
    <form action="{{ route('installer.set_database') }}" method="POST">
        @csrf
        
        <div class="form-group">
            <label for="db_host" class="form-label">
                <i class="fas fa-server" style="margin-right: var(--spacing-xs); color: var(--primary-color);"></i>
                Database Host
            </label>
            <input type="text" id="db_host" name="db_host" class="form-control" value="{{ old('db_host', '127.0.0.1') }}" required>
            @if($errors->has('db_host'))
                <div style="color: var(--danger); margin-top: var(--spacing-xs); font-size: 0.9rem;">
                    {{ $errors->first('db_host') }}
                </div>
            @endif
        </div>
        
        <div class="form-group">
            <label for="db_port" class="form-label">
                <i class="fas fa-plug" style="margin-right: var(--spacing-xs); color: var(--primary-color);"></i>
                Database Port
            </label>
            <input type="number" id="db_port" name="db_port" class="form-control" value="{{ old('db_port', '3306') }}" required>
            @if($errors->has('db_port'))
                <div style="color: var(--danger); margin-top: var(--spacing-xs); font-size: 0.9rem;">
                    {{ $errors->first('db_port') }}
                </div>
            @endif
        </div>
        
        <div class="form-group">
            <label for="db_database" class="form-label">
                <i class="fas fa-database" style="margin-right: var(--spacing-xs); color: var(--primary-color);"></i>
                Database Name
            </label>
            <input type="text" id="db_database" name="db_database" class="form-control" value="{{ old('db_database') }}" placeholder="mydatabase" required>
            @if($errors->has('db_database'))
                <div style="color: var(--danger); margin-top: var(--spacing-xs); font-size: 0.9rem;">
                    {{ $errors->first('db_database') }}
                </div>
            @endif
        </div>
        
        <div class="form-group">
            <label for="db_username" class="form-label">
                <i class="fas fa-user" style="margin-right: var(--spacing-xs); color: var(--primary-color);"></i>
                Database Username
            </label>
            <input type="text" id="db_username" name="db_username" class="form-control" value="{{ old('db_username', 'root') }}" required>
            @if($errors->has('db_username'))
                <div style="color: var(--danger); margin-top: var(--spacing-xs); font-size: 0.9rem;">
                    {{ $errors->first('db_username') }}
                </div>
            @endif
        </div>
        
        <div class="form-group">
            <label for="db_password" class="form-label">
                <i class="fas fa-lock" style="margin-right: var(--spacing-xs); color: var(--primary-color);"></i>
                Database Password
            </label>
            <input type="password" id="db_password" name="db_password" class="form-control" value="{{ old('db_password') }}">
            @if($errors->has('db_password'))
                <div style="color: var(--danger); margin-top: var(--spacing-xs); font-size: 0.9rem;">
                    {{ $errors->first('db_password') }}
                </div>
            @endif
        </div>
        
        <div style="margin-top: var(--spacing-lg); background-color: rgba(255, 193, 7, 0.1); border-radius: var(--border-radius-md); padding: var(--spacing-md); border: 1px solid rgba(255, 193, 7, 0.2);">
            <div style="display: flex; align-items: flex-start;">
                <i class="fas fa-info-circle" style="color: var(--warning); margin-right: var(--spacing-sm); margin-top: 3px;"></i>
                <p style="font-size: 0.9rem; margin: 0;">
                    If the database does not exist, we'll attempt to create it for you. Make sure the database user has sufficient privileges.
                </p>
            </div>
        </div>
    @endsection

    @section('footer')
        <a href="{{ route('installer.license') }}" class="btn">
            <i class="fas fa-arrow-left"></i> Back
        </a>
        <button type="submit" class="btn btn-primary">
            <i class="fas fa-database"></i> Verify Connection
        </button>
    </form>
@endsection